//////////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//////////////////////////////////////////////////////////////////////////////

#include "../inc/rom.h"


////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT8	*ws_rom_load(char *path, UINT32 *romSize)
{
	//s2d::Log::Output("Loading rom:  %s \n",path);

	UINT8	*rom=NULL;
	s2d::s32 filepos;
	FILE *fp=fopen(path,"rb");
	if (fp==NULL)
		return(NULL);

	fseek(fp,0,SEEK_END);
	fgetpos(fp,&filepos);
	*romSize=(int)filepos;
	fseek(fp,0,SEEK_SET);
	rom=(UINT8*)malloc(*romSize);
	fread(rom,1,*romSize,fp);

	fclose(fp);	

	//s2d::Log::Output("Loaded rom:  %s \n",path);

	return(rom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void	ws_rom_dumpInfo(UINT8 *wsrom, UINT32 romSize)
{
	ws_romHeaderStruct		*romHeader=ws_rom_getHeader(wsrom,romSize);

	//fwrite(&Scene, sizeof(s32),m_fp );

	//s2d::Log::Output("rom: developper Id  0x%.2x\n",romHeader->developperId);
	//s2d::Log::Output("rom: cart Id        0x%.2x\n",romHeader->cartId);
	//s2d::Log::Output("rom: minimum system %s\n",(romHeader->minimumSupportSystem==WS_SYSTEM_MONO)?"Wonderswan mono":"Wonderswan color");
	//s2d::Log::Output("rom: size           %i Mbits\n",(romSize>>20)<<3);
	//s2d::Log::Output("rom: eeprom         ");
	switch (romHeader->eepromSize&0xf)
	{
	case WS_EEPROM_SIZE_NONE:	{ 
		//s2d::Log::Output("none\n"); 
		break; }
	case WS_EEPROM_SIZE_64k:	{ 
		//s2d::Log::Output("64 kb\n"); 
		break; }
	case WS_EEPROM_SIZE_256k:	{ 
		//s2d::Log::Output("256 kb\n"); 
		break; }
	}
	//s2d::Log::Output("rom: sram           ");
	switch (romHeader->eepromSize&0xf0)
	{
	case WS_SRAM_SIZE_NONE:	{ 
		//s2d::Log::Output("none\n"); 
		break; }
	case WS_SRAM_SIZE_1k:	{ 
		//s2d::Log::Output("1 kb\n"); 
		break; }
	case WS_SRAM_SIZE_16k:	{ 
		//s2d::Log::Output("16 kb\n"); 
		break; }
	case WS_SRAM_SIZE_8k:	{ 
		//s2d::Log::Output("8 kn\n"); 
		break; }
	}
	
	//s2d::Log::Output("rom: rtc            %s\n",(romHeader->realtimeClock)?"Yes":"None");
	//s2d::Log::Output("checksum            0x%.4x\n",romHeader->checksum);
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
ws_romHeaderStruct		*ws_rom_getHeader(UINT8 *wsrom, UINT32 wsromSize)
{
	ws_romHeaderStruct *wsromHeader=(ws_romHeaderStruct *)malloc(sizeof(ws_romHeaderStruct));

	memcpy((char*)wsromHeader,(char*)wsrom+(wsromSize-10),10);
	return(wsromHeader);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT32				ws_rom_sramSize(UINT8 *wsrom, UINT32 wsromSize)
{
	ws_romHeaderStruct		*romHeader=ws_rom_getHeader(wsrom,wsromSize);
	switch (romHeader->eepromSize&0xf0)
	{
	case WS_SRAM_SIZE_NONE:		return(0);
	case WS_SRAM_SIZE_1k:		return(0x400);
	case WS_SRAM_SIZE_16k:		return(0x4000);
	case WS_SRAM_SIZE_8k:		return(0x2000);
	}
	return(0);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT32				ws_rom_eepromSize(UINT8 *wsrom, UINT32 wsromSize)
{
	ws_romHeaderStruct		*romHeader=ws_rom_getHeader(wsrom,wsromSize);
	switch (romHeader->eepromSize&0xf)
	{
	case WS_EEPROM_SIZE_NONE:	return(0);
	case WS_EEPROM_SIZE_64k:	return(0x10000);
	case WS_EEPROM_SIZE_256k:	return(0x40000);
	}
	return(0);
}

